/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.beans;

import filenet.vw.api.VWMilestoneElement;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.IVWPanelComponent;
import filenet.vw.toolkit.runtime.step.IVWStepProcessorComponent;
import filenet.vw.toolkit.runtime.step.beans.VWComboBox;
import filenet.vw.toolkit.runtime.step.beans.VWLabel;
import filenet.vw.toolkit.runtime.step.beans.VWTextArea;
import filenet.vw.toolkit.runtime.step.beans.VWTextField;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Beans;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class VWTabbedPane
extends JTabbedPane
implements IVWStepProcessorComponent {
    private VWStepElement m_vwStepElement = null;
    private Frame m_parentFrame = null;
    private VWSession m_vwSession = null;
    private Vector m_componentList = null;
    private boolean m_hasResponses = false;
    private VWTextArea m_commentsTextArea = null;
    private boolean m_showGeneralInfo = true;
    private Font m_plainFont = null;

    public VWTabbedPane() {
        try {
            this.m_componentList = new Vector();
            Font font = this.getFont();
            if (font != null) {
                this.m_plainFont = new Font(font.getName(), 0, font.getSize());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_commentsTextArea != null) {
            this.m_commentsTextArea.requestFocus();
        }
    }

    public void setShowGeneralInfo(boolean showGeneral) {
        this.m_showGeneralInfo = showGeneral;
    }

    public boolean doSave() {
        try {
            if (this.m_componentList == null) {
                return true;
            }
            if (this.m_vwStepElement == null) {
                return false;
            }
            for (int i = 0; i < this.m_componentList.size(); ++i) {
                Object obj = this.m_componentList.elementAt(i);
                if (!(obj instanceof IVWPanelComponent ? !((IVWPanelComponent)obj).doSave() : obj instanceof IVWStepProcessorComponent && !((IVWStepProcessorComponent)obj).doSave())) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), "Failed Saving Step", 1, null);
            VWDebug.logException(ex);
            return false;
        }
    }

    public void init(VWStepElement stepElement, Frame parentFrame, VWSession session) {
        this.m_vwStepElement = stepElement;
        this.m_parentFrame = parentFrame;
        this.m_vwSession = session;
        if (this.m_vwStepElement == null) {
            return;
        }
        try {
            if (this.m_vwStepElement.hasParameterName("F_Responses") && this.m_vwStepElement.getStepResponses() != null) {
                this.m_hasResponses = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.createControls();
    }

    private void createControls() {
        JComponent newComponent = null;
        int nTabs = 0;
        VWProcess process = null;
        VWMilestoneElement[] milestoneElements = null;
        try {
            if (this.m_vwStepElement.hasParameterName("F_Comment") || this.m_hasResponses) {
                this.add(this.getGeneralPanel());
                this.setTitleAt(nTabs, VWResource.s_general);
                ++nTabs;
            }
            if (this.m_vwStepElement.getParameters(32, 1) != null && (newComponent = (JComponent)Beans.instantiate(this.getClass().getClassLoader(), "filenet.vw.toolkit.runtime.step.beans.VWAttachmentPanel")) != null) {
                if (newComponent instanceof IVWStepProcessorComponent) {
                    ((IVWStepProcessorComponent)((Object)newComponent)).init(this.m_vwStepElement, this.m_parentFrame, this.m_vwSession);
                }
                this.m_componentList.addElement(newComponent);
                this.add(newComponent);
                this.setTitleAt(nTabs, VWResource.s_attachments);
                ++nTabs;
            }
            if (this.m_vwStepElement.getParameters(159, 1) != null && (newComponent = (JComponent)Beans.instantiate(this.getClass().getClassLoader(), "filenet.vw.toolkit.runtime.step.beans.VWFieldPanel")) != null) {
                if (newComponent instanceof IVWStepProcessorComponent) {
                    ((IVWStepProcessorComponent)((Object)newComponent)).init(this.m_vwStepElement, this.m_parentFrame, this.m_vwSession);
                }
                this.m_componentList.addElement(newComponent);
                this.add(newComponent);
                this.setTitleAt(nTabs, VWResource.s_dataFields);
                ++nTabs;
            }
            if ((this.m_vwStepElement.getParameters(64, 1) != null || this.m_vwStepElement.hasParameterName("F_Trackers")) && (newComponent = (JComponent)Beans.instantiate(this.getClass().getClassLoader(), "filenet.vw.toolkit.runtime.step.beans.VWWflGroupPanel")) != null) {
                if (newComponent instanceof IVWStepProcessorComponent) {
                    ((IVWStepProcessorComponent)((Object)newComponent)).init(this.m_vwStepElement, this.m_parentFrame, this.m_vwSession);
                }
                this.m_componentList.addElement(newComponent);
                this.add(newComponent);
                this.setTitleAt(nTabs, VWResource.s_workflowGroups);
                ++nTabs;
            }
            if (!this.m_vwStepElement.getIsLaunchStep()) {
                try {
                    process = this.m_vwStepElement.fetchProcess();
                    if (process != null) {
                        milestoneElements = process.fetchFilteredWorkflowMilestones(1, true, true);
                    }
                }
                catch (Exception ex) {
                    milestoneElements = null;
                }
                try {
                    if (milestoneElements != null && milestoneElements.length > 0 && (newComponent = (JComponent)Beans.instantiate(this.getClass().getClassLoader(), "filenet.vw.toolkit.runtime.step.beans.VWMilestonePanel")) != null) {
                        if (newComponent instanceof IVWStepProcessorComponent) {
                            ((IVWStepProcessorComponent)((Object)newComponent)).init(this.m_vwStepElement, this.m_parentFrame, this.m_vwSession);
                        }
                        this.m_componentList.addElement(newComponent);
                        this.add(newComponent);
                        this.setTitleAt(nTabs, VWResource.s_milestones);
                        ++nTabs;
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
            this.setSelectedIndex(0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getGeneralPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.fill = 0;
            gbCons.insets = new Insets(4, 4, 4, 4);
            gbCons.ipadx = 0;
            gbCons.ipady = 0;
            if (this.m_showGeneralInfo) {
                this.addGeneralInfo(panel, gbCons);
                gbCons.fill = 0;
                gbCons.gridx = 0;
                ++gbCons.gridy;
            }
            if (this.m_hasResponses) {
                gbCons.gridwidth = -1;
                gbCons.weightx = 0.0;
                panel.add((Component)new JLabel(VWResource.s_responseColon), gbCons);
                ++gbCons.gridx;
                gbCons.gridwidth = 0;
                gbCons.weightx = 1.0;
                VWComboBox responsesCombo = new VWComboBox();
                responsesCombo.setParameterName("F_Responses");
                responsesCombo.setStepElement(this.m_vwStepElement);
                panel.add((Component)responsesCombo, gbCons);
                this.m_componentList.addElement(responsesCombo);
                gbCons.gridx = 0;
                ++gbCons.gridy;
            }
            if (this.m_vwStepElement.hasParameterName("F_Comment")) {
                gbCons.weightx = 0.0;
                gbCons.gridwidth = 0;
                panel.add((Component)new JLabel(VWResource.s_commentsColon), gbCons);
                gbCons.gridx = 0;
                ++gbCons.gridy;
                gbCons.weightx = 1.0;
                gbCons.weighty = 1.0;
                gbCons.fill = 1;
                this.m_commentsTextArea = new VWTextArea();
                this.m_commentsTextArea.setParameterName("F_Comment");
                this.m_commentsTextArea.setStepElement(this.m_vwStepElement);
                this.m_commentsTextArea.setLineWrap(true);
                this.m_commentsTextArea.setWrapStyleWord(true);
                JScrollPane scrollPane = new JScrollPane(this.m_commentsTextArea);
                scrollPane.setOpaque(true);
                panel.add((Component)scrollPane, gbCons);
                this.m_componentList.addElement(this.m_commentsTextArea);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private void addGeneralInfo(JPanel panel, GridBagConstraints gbCons) {
        try {
            panel.add((Component)new JLabel(VWResource.s_subjectColon), gbCons);
            ++gbCons.gridx;
            gbCons.weightx = 1.0;
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            VWTextField vwTextField = new VWTextField();
            vwTextField.setParameterName("F_Subject");
            vwTextField.setStepElement(this.m_vwStepElement);
            panel.add((Component)vwTextField, gbCons);
            this.m_componentList.addElement(vwTextField);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            if (!this.m_vwStepElement.getIsLaunchStep()) {
                gbCons.gridx = 0;
                gbCons.weightx = 0.0;
                gbCons.gridwidth = 1;
                gbCons.fill = 0;
                JLabel label = new JLabel(VWResource.s_launchedByColon);
                label.setHorizontalAlignment(2);
                panel.add((Component)label, gbCons);
                ++gbCons.gridx;
                gbCons.weightx = 1.0;
                gbCons.fill = 2;
                VWLabel vwLabel = new VWLabel();
                vwLabel.setParameterName("F_Originator");
                if (this.m_plainFont != null) {
                    vwLabel.setFont(this.m_plainFont);
                }
                vwLabel.setHorizontalTextPosition(2);
                vwLabel.setStepElement(this.m_vwStepElement);
                panel.add((Component)vwLabel, gbCons);
                ++gbCons.gridx;
                gbCons.weightx = 0.0;
                gbCons.fill = 0;
                label = new JLabel(VWResource.s_launchedOnColon);
                label.setHorizontalAlignment(2);
                panel.add((Component)label, gbCons);
                ++gbCons.gridx;
                gbCons.weightx = 1.0;
                gbCons.fill = 2;
                vwLabel = new VWLabel();
                vwLabel.setParameterName("F_LaunchDate");
                if (this.m_plainFont != null) {
                    vwLabel.setFont(this.m_plainFont);
                }
                vwLabel.setHorizontalTextPosition(2);
                vwLabel.setStepElement(this.m_vwStepElement);
                panel.add((Component)vwLabel, gbCons);
                gbCons.gridx = 0;
                ++gbCons.gridy;
                gbCons.weightx = 0.0;
                gbCons.fill = 0;
                label = new JLabel(VWResource.s_deadlineColon);
                label.setHorizontalAlignment(2);
                panel.add((Component)label, gbCons);
                ++gbCons.gridx;
                gbCons.weightx = 1.0;
                gbCons.fill = 2;
                vwLabel = new VWLabel();
                vwLabel.setParameterName("F_DeadLine");
                if (this.m_plainFont != null) {
                    vwLabel.setFont(this.m_plainFont);
                }
                vwLabel.setHorizontalTextPosition(2);
                vwLabel.setStepElement(this.m_vwStepElement);
                panel.add((Component)vwLabel, gbCons);
                ++gbCons.gridx;
                gbCons.weightx = 0.0;
                gbCons.fill = 0;
                label = new JLabel(VWResource.s_receivedOnColon);
                label.setHorizontalAlignment(2);
                panel.add((Component)label, gbCons);
                ++gbCons.gridx;
                gbCons.weightx = 1.0;
                gbCons.fill = 2;
                vwLabel = new VWLabel();
                vwLabel.setParameterName("F_DateReceived");
                if (this.m_plainFont != null) {
                    vwLabel.setFont(this.m_plainFont);
                }
                vwLabel.setHorizontalTextPosition(2);
                vwLabel.setStepElement(this.m_vwStepElement);
                panel.add((Component)vwLabel, gbCons);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

